/**
* \file: GstreamerVideoPipeline.h
*
* \version: 1.0
*
* \release: $Name:$
*
* Configuration of GstreamerVideoSink.
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
************************************************************************/

#ifndef BDCL_GSTREAMERVIDEOPIPELINE_H_
#define BDCL_GSTREAMERVIDEOPIPELINE_H_
#include <gst/gst.h>
#include <string>
#include <sys/prctl.h>

namespace adit { namespace bdcl {

void MessageBusAddRef();
void MessageBusUnref();

class GstreamerVideoPipeline
{
public:
    GstreamerVideoPipeline();
    ~GstreamerVideoPipeline();

    bool CreatePipeline(const std::string& inAppSrcName, const std::string& inPartialBinName, const std::string& inPipeline);
    void StopPipeline();

    pthread_cond_t stopCondition;
    pthread_mutex_t stopConditionMutex;
    bool stopped;

    GstElement * appsrc;
    GstElement* partial;
    GstElement* gstVideoSink;
    GstElement* pipeline;

private:
    bool CreatePartialBin(const std::string& inName, const std::string& inPipeline);



    GstBus* bus;
    guint watchId;

    bool setThreadPrio; //todo Dont know to which thread the priority has to be set.
    uint32_t threadPrio;

};
gboolean busCallBack(GstBus* inBus, GstMessage* inMessage, gpointer inPointer);


} } /*namespace adit { namespace bdcl { */

#endif /* BDCL_GSTREAMERVIDEOPIPELINE_H_ */
